local TABAS_UnEquipItems = {} 

local TABAS_Utils = require("TABAS_Utils")

local function shouldBeDrop(item, Attached)
    if item == nil then return end
    
    local doDropAll = TABAS_Utils.ModOptionsValue("DropEquippedItemsAll")
    local doDropBack = TABAS_Utils.ModOptionsValue("DropEquippedItemsBack")
    local doDropConatiner = TABAS_Utils.ModOptionsValue("DropEquippedItemsConatiner")
    local doDropAttached = TABAS_Utils.ModOptionsValue("DropEquippedItemsAttached")
    local doDropHand = TABAS_Utils.ModOptionsValue("DropEquippedItemsHand")
    local doDropClothing = TABAS_Utils.ModOptionsValue("DropEquippedItemsClothing")
    local weightLimit = TABAS_Utils.ModOptionsValue("DropEquippedItemsWeight")

    if not item:isFavorite() then
        if doDropAll then
            return true
        elseif doDropBack and item:canBeEquipped() and item:canBeEquipped() == "Back" then
            return true
        elseif doDropConatiner and item:IsInventoryContainer() then
            return true
        elseif doDropAttached and Attached then
            return true
        elseif doDropHand and (item:isHandItem() or item:isTwoHandWeapon()) then
            return true
        elseif doDropClothing and instanceof(item, "Clothing") then
            return true
        end
    end
    if weightLimit > 0 and item:getActualWeight() >= weightLimit then
        return true
    end
    return false
end

local function getHotbarAttachments(player)
    local hotbar = getPlayerHotbar(player)
    if not hotbar then return end
    
    local playerObj = getSpecificPlayer(player)
    local doDropAttached = TABAS_Utils.ModOptionsValue("DropEquippedItemsAttached")
    local hotbarAttachments = {}
    local attachedItem = {}
    for i, item in pairs(hotbar.attachedItems) do
        local slot = hotbar.availableSlot[i]
        if item and slot then
            local slotDef = slot.def
            if slotDef and slotDef.type then
                local slotIndex = hotbar:getThisSlotIndex(slotDef.type)
                attachedItem = {item = item, slot = slot, slotIndex = slotIndex}
                table.insert(hotbarAttachments, attachedItem)
                -- hotbar:removeItem(item, doAnim)
                -- doAnim = false
                -- if slotDef.name == "Back" then
                    if doDropAttached and not playerObj:isEquipped(item) then
                        ISTimedActionQueue.add(ISInventoryTransferAction:new(playerObj, item, item:getContainer(), ISInventoryPage.floorContainer[player + 1]))
                    elseif slotDef.name == "Back" then
                        hotbar:removeItem(item, false)
                    -- end
                end
            end
        end
    end
    return hotbarAttachments
end

function TABAS_UnEquipItems.doUnequip(player, asIsWearing, excludeItemType)
    local playerObj = getSpecificPlayer(player)
    local modData = playerObj:getModData()
    local equippedItems = {}
    local modifyTime = TABAS_Utils.ModOptionsValue("WearingActionTime")
    local unequipTime = 50
    local unwearTime = 25
    local unwearTime2 = 25
    if modifyTime == 2 then
        unwearTime = 75
        unwearTime2 = 1
    elseif modifyTime == 3 then
        unwearTime = 50
        unwearTime2 = 50
    end
    -- Hotbar Items
    if not asIsWearing then
        local hotbarAttachedItems = getHotbarAttachments(player)
        if #hotbarAttachedItems > 0 then
            equippedItems.HotbarAttachedItems = hotbarAttachedItems
        end
    end
    local item
    -- Secondary or TowHand Item
    if playerObj:getSecondaryHandItem() ~= nil then
        item = playerObj:getSecondaryHandItem()
        equippedItems.Secondary = item
        if item:isTwoHandWeapon() and playerObj:isItemInBothHands(item) then
            equippedItems.TowHand = true
        end
        if shouldBeDrop(item) then
            ISInventoryPaneContextMenu.dropItem(item, player)
        else
            ISTimedActionQueue.add(ISUnequipAction:new(playerObj, item, unequipTime))
            unequipTime = 30
        end
    end
    -- Primary Item
    if playerObj:getPrimaryHandItem() ~= nil and not equippedItems.TowHand then
        item = playerObj:getPrimaryHandItem()
        equippedItems.Primary = item
        if shouldBeDrop(item) then
            ISInventoryPaneContextMenu.dropItem(item, player)
        else
            ISTimedActionQueue.add(ISUnequipAction:new(playerObj, item, unequipTime))
        end
    end
    
    -- Worn Items
    if not asIsWearing then
        local wornItems = playerObj:getWornItems()
        if wornItems then
            equippedItems.WornClothes = {}
            for i=0, wornItems:size()-1 do
                item = wornItems:get(i):getItem()
                if item and (instanceof(item, "Clothing") or instanceof(item, "InventoryContainer")) then
                    if TABAS_Utils.isNotExcludedClothing(item, excludeItemType) then
                        table.insert(equippedItems.WornClothes, item)
                    end
                end
            end
        end
        -- Raw the wornItems table order would mean that the underwear would be unequip first, 
        -- so need to reverse the order of the wornItem table before action queue.
        if #equippedItems.WornClothes > 0 then
            local reversed = {}
            local itemCount = #equippedItems.WornClothes
            for i=0, #equippedItems.WornClothes do
                reversed[itemCount - i] = equippedItems.WornClothes[i]
            end
            for i=0, #reversed do
                if shouldBeDrop(reversed[i]) then
                    -- ISInventoryPaneContextMenu.dropItem(reversed[i], player)
                    ISTimedActionQueue.add(ISInventoryTransferAction:new(playerObj, reversed[i], playerObj:getInventory(), ISInventoryPage.floorContainer[player + 1], unwearTime))
                else
                    ISTimedActionQueue.add(ISUnequipAction:new(playerObj, reversed[i], unwearTime))
                end
                unwearTime = unwearTime2
            end
        end
    end
    modData.tabasEquippedItems = equippedItems
end

return TABAS_UnEquipItems
